﻿CREATE PROCEDURE [App].[NVCC_usp_CurrentUsage]
	-- @timeframe is the number of minutes (positive) to look backwards for usage
	@timeframe numeric
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_CurrentUsage
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-01-2016
--
--Last Changed          : 2017-03-29
--Last Changed By		: Brian Diggs (Northwest Innovation Center)
--Reason For Change		: Temporary workaround for different servers recording timestamp
--                        in local time
--
--Purpose               : To get most recent users/usage
--==================================================================================
--Uses: App.NVCC_AccessLog
BEGIN
	WITH
		-- 2 hour shift due to differences in timezones of SQL server and application server
		LastTime AS (SELECT DATEADD(hour, -2, getdate()) AS LastTimestamp),
		-- Pull the log entries for this time frame to use as a source for the other queries
		RecentLogs AS (
			SELECT *
			FROM App.NVCC_AccessLog
			CROSS JOIN LastTime
			WHERE ((HostName = 'DND.URL       ' AND AccessDateTime > dateadd(minute, -(@timeframe), LastTime.LastTimestamp))
				OR (HostName = 'vaww.refdoc.va.gov' AND AccessDateTime > dateadd(hour, 3, dateadd(minute, -(@timeframe), LastTime.LastTimestamp))))
		)
		SELECT
			Users.HostName,
			Users.UserID,
			Users.LastLoggedEvent,
			Time.MeanLookupTime,
			Users.NumberLookups,
			Users.NumberPackages
		FROM (
			-- For each combination of host/user, compute some statistics
			SELECT
				HostName, 
				UserID,
				MAX(AccessDateTime) AS LastLoggedEvent,
				SUM(CASE WHEN Action = 'PatientProfile' THEN 1 ELSE 0 END) AS NumberLookups, 
				SUM(CASE WHEN Action = 'PDF' THEN 1 ELSE 0 END) AS NumberPackages
			FROM RecentLogs
			GROUP BY HostName, UserID
		) AS Users
		LEFT JOIN (
			-- MeanLookupTime is more easily computed separately because it
			-- needs just a subset of the data
			SELECT
				HostName, UserID, AVG(ElapsedTime) AS MeanLookupTime
			FROM RecentLogs
			WHERE Action = 'PatientProfile'
			GROUP BY HostName, UserID
		) AS Time
			ON Users.Hostname = Time.HostName and Users.UserID = Time.UserID
		ORDER BY
			HostName,
			LastLoggedEvent DESC
END

